<!-- Title: Design Sprint -->

This template outlines a sample set-up process, activities and deliverables for running a Remote Design Sprint. The specific activities and deliverables should be customized based on your objectives and timeline. 

Please refer to the [Remote Design Sprint Handbook page](#anchor-tag-to-handbook-page) for additional recommendations.

## Design Sprint Focus
* [ ] Have you [determined that a Design Sprint is appropriate for this project](#anchor-tag-to-handbook-page)?
<!-- What is the focus of the [Design Sprint](https://about.gitlab.com/handbook/product/product-processes/#design-sprint)? What problem area will you be solving for and who is the target user? -->

## Objectives

<!-- Try to describe the objectives of the Sprint in detail. eg "We want to introduce a new feature but we are unsure that we are thinking about the solution from the customer's perspective and through the Sprint we want to rethink the solution, prototype it and validate it with our customers" or "We are unhappy with the direction of one of our categories and we want to explore new directions with different stakeholders, reach to one solution and test it with users" or "Among the team we have different visions for a specific category and we want to work towards a solution we all support and test it with users".  --> 

## Outputs

- [ ] A User testing flow.
- [ ] A Prototype to be tested with users.
- [ ] User testing analysis. 
- [ ] (If the solution is viable) An epic or issue that describes the direction in details and the next steps
- [ ] Necessary updates to the Handbook.

## Design Sprint Details

| Start | End |
| ------ | ------ |
| YYYY-MM-DD | YYYY-MM-DD |
| TT:TT PST | TT:TT PST |


### WHEN 

**Start date:**

**End date:**

**Reference time zone:**

### WHERE

**Zoom link:**

### WHO

   - `Name` `gitlab handle` - Facilitator 
   - `Name` `gitlab handle` - Decider (usually the Product Manager)
   - `Name` `gitlab handle` - Co-decider (optional)
   - `Name` `gitlab handle` - Sprint team member
   - `Name` `gitlab handle` - Sprint team member
   - `Name` `gitlab handle` - Sprint team member
   - `Name` `gitlab handle` - Sprint team member
   - `Name` `gitlab handle` - Sprint team member
   - `Name` `gitlab handle` - Sprint team member
   - `Name` `gitlab handle` - Co-facilitator (optional)

## Tools
Here is the list of tools for the Sprint preparation, collaboration and documentation. Prior to the Sprint make sure you have access to all of the following:

*  **GitLab**<br/>
Each Sprint day outcomes and material will be documented in a separate issue under the Design Sprint epic. 

* **Mural** (You can join as anonymous but we need to be able to identify input against names, so please create an account beforehand.<br/>
We will use Mural for most of the Sprint collaboration. Some of the things we will do in Mural: 
    * Create artifacts like affinity diagrams from participants' input
    * Use post-its to comment on each other's points and to add notes
    * Vote on ideas and solutions
    * Create the first draft of the prototype.
The Mural link to the collaboration project will be provided in the issue before the start of the Design Sprint.

* **Video and/or screen recording tool** (Loom, Quicktime, Zoom or another tool you are using).<br/>
As part of the pre-Sprint homework, you will be asked to record a short Lightning Walkthrough video. You can use any tool you feel comfortable with as long as it can capture your screen, mouse pointer and your audio.

* **A4/Letter sized paper (preferably white blank), Sharpies/Pens** (please don't use a pencil because it doesn't create enough contrast for photos).<br/>
Day 2 of the sprint involves some (async) ideation via sketching so you will need a writing utensil (Sharpies are preferred because they force you to draw at a lower fidelity because the small details aren't necessary at this point) and some paper. This is the most fun part of the Sprint where you get into a design thinking mindset and can appeal to your creative self. Don't worry, it's not about artistry, it's about ideas and collaboration.

* **Camera (phone or other) or scanner**<br/>
You will need to upload sketches as images for the facilitator to prepare the material before the next sync meeting. You can take a photo with your phone or use a scanner if available.

* **Post-it notes (Optional)**<br/>
If you enjoy taking notes using post-it notes make sure you have available some of them as well. The upside is that they will make you feel more like you are in a workshop and will help the ideas flow (I find that typing is distracting while ideating). The downside is that you will have to digitalise the ones you want to share with the team in Mural.

## Artefacts & Pre-Read Material

<!-- If there is material that will be useful for the participants to read before the Design Sprint add here. -->

### Handbook pages
<!-- Add a link to the category vision from the handbook -->

### Competitor resources
<!-- Add any solutions by competitors that are relevant to the Design Sprint topic and could be used as source of inspiration. -->


### Articles on Design Sprints
  * [The Design Sprint](https://www.gv.com/sprint/)
  * [The Ultimate Guide To Remote Design Sprints](https://drive.google.com/file/d/16bwrAqHVf8qxovd87Q7LdzqwAgy7a6Rx/view?usp=sharing)

## Asyncronus tasks

### Design Sprint preparation

<!-- Replace the roles with GitLab handles to assign to specific participants -->

- [ ] Finalise participant list - `decider` and `facilitator`
- [ ] Create [participation form](https://docs.google.com/forms/d/e/1FAIpQLSc0_BNltvRW8yXXaJd8sIKzgDmrSGqILMfkoCJrAj6sFcsMcg/viewform?usp=sf_link) and send to participants (**deadline**: [date]) - `facilitator` 
- [ ] Create a dedicated Slack channel and add participants - `facilitator`
- [ ] Promote this issue to an epic - `facilitator`
- [ ] Create issues under the epic for the pre-workshop tasks: Expert interviews ([example](https://gitlab.com/groups/gitlab-org/configure/-/epics/3#note_332412524)), Lightning walkthroughs and How might we.. notetaking assignment ([example](https://gitlab.com/gitlab-org/configure/general/-/issues/52)), Voting How might we... notes assignment ([example](https://gitlab.com/gitlab-org/configure/general/-/issues/54)) - `facilitator` 
- [ ] Create sync meetings in calendar and invite all participants (**deadline**: [date]) - `decider` or `facilitator` 
- [ ] Block 2 hours for Sprint activities in calendar for the Sprint week - `all participants`
- [ ] Prepare material and tools (eg. presentation templates, Google folders, Instructions videos etc) and Mural board from the [Mural template ](https://app.mural.co/invitation/mural/gitlab2474/1586990879319?sender=jmandell0210&key=03c25e92-9a43-4a3d-8907-6f0c3b094ab8) - facilitator 
- [ ] Finalize Agenda - `facilitator` 
- [ ] Run a test with material and tools - `facilitator` 
- [ ] Start user recruiting for prototype user testing (EOD 1) - `facilitator` or `decider`

### Pre-Sprint activities (Homework exercises)

Each exercise should be explained and documented in a separate issue. You can use the example issues above as templates.

- [ ] Fill form and submit (**deadline**: [date]) - `all participants except the facilitator`
- [ ] Expert interview analysis - `facilitator`
- [ ] Lightning walkthrough videos (**deadline**: [date]) - `all participants except the facilitator`
- [ ] How might we... notetaking assignment (**deadline**: [date]) - `all participants except the facilitator`
- [ ] Voting How might we... notes assignment (**deadline**: [date]) - `all participants except the facilitator`
- [ ] Add all required material to the Mural board (**deadline**: [date]) - `facilitator`

### During Sprint activities

- [ ] Organise user testing sessions - `facilitator` or `decider`
- [ ] Create the Prototype to be tested and task list (End of Day 3) - `Product designer` or `Front end developer`
- [ ] Run user testing sessions - `facilitator` or `decider`

### Post-Sprint activities

- [ ] Create a feedback issue for the Design Sprint - `facilitator` or `decider` 
- [ ] Analyse user testing results - `facilitator` or `decider`
- [ ] Create report and share with the Design Sprint participants and wider team - `facilitator` or `decider`

## Personas

Deciding which persona we are focusing on will be part of the Day 1 discussions in the workshop. The personas we are going to consider are:

<!-- Choose which personas could be target users so that you choose from this list during the Sprint. Personas are described at https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/

* [Cameron (Compliance Manager)](https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/#cameron-compliance-manager)
* [Parker (Product Manager)](https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/#parker-product-manager)
* [Delaney (Development Team Lead)](https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/#delaney-development-team-lead)
* [Presley (Product Designer)](https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/#presley-product-designer)
* [Sasha (Software Developer)](https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/#sasha-software-developer)
* [Priyanka (Platform Engineer)](https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/#priyanka-platform-engineer)
* [Sidney (Systems Administrator)](https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/#sidney-systems-administrator)
* [Sam (Security Analyst)](https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/#sam-security-analyst)
* [Rachel (Release Manager)](https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/#rachel-release-manager)
* [Alex (Security Operations Engineer)](https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/#alex-security-operations-engineer)
* [Simone (Software Engineer in Test)](https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/#simone-software-engineer-in-test)
* [Allison (Application Ops)](https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/#allison-application-ops)
* [Ingrid (Infrastructure Operator)](https://about.gitlab.com/handbook/product/personas/#ingrid-infrastructure-operator)
* [Dakota (Application Development Director)](https://about.gitlab.com/handbook/product/personas/#dakota-application-development-director)
* [Dana (Data Analyst)](https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/#dana-data-analyst)
* [Eddie (Content Editor)](https://about.gitlab.com/handbook/marketing/product-marketing/roles-personas/#eddie-content-editor)

-->

## Agenda
### Day 1

 |  Activity  | Duration | Tool  | Description  |
|---|---|---|---|
|  Warm-up exercise  |  5 mins | Mural  |  Write 1 post-it answering the questions: <br/>"My name is…"<br/>"My role is…"<br/>“Something about myself you may not know is…”<br/>"My wish for this workshop is…" |
| Summarise the async activities & complete Map | 20 mins | Mural  |  The Map is intended to show the focus of the Sprint and doesn't need to be complete or detailed. Steps:<br/>  Go through the Map and the top voted How might we’s tree as a warm-up/reminder. <br/> • Make appropriate adjustments and additions to the map based on the reviews from the team. <br/> • Add the most voted HMWs to the most relevant area on the Map. If a HMW can go to more than one place, add it to the most left area. |
| Long term goals/Deciding the Sprint goal | 15 mins | Mural  | • Long term goal: Everyone spends 5 minutes in silence and writes one (max 2) long term goal post-it note for the Sprint. (5 mins ) <br/> • One by one everyone will read their goal aloud to the team. (5 mins) <br/> Everyone besides the decider will vote on the goal of the Sprint (1 dot). (4 minutes) <br/> The decider then makes the final decision on the long term goal of the Sprint. (1 min) |
 | Sprint questions | 20 mins | Mural | • Referencing the Long Term goal, everyone will write 2-3 post-it note Sprint questions for the biggest challenges they think might stop us from achieving our long term goal (what might hold us back or hinder us from achieving this goal). The questions should start with “Can we...” (similarly to the HMW). (7 mins) <br/> • One by one everyone will read their Sprint questions aloud to the team. (5 mins) <br/> • Everyone (including the decider) votes on the top 3 questions they think we should focus on as Sprint challenges (3 dots). (5 mins) <br/> • Separate the 3 most voted questions and keep them on the side. (1 min) <br/> • Finally, the decider chooses one Sprint question that will be the question we will focus on more during the Sprint by placing a green smiley sticker on it. (1 min) <br/> • Move the long term goal and the Sprint questions to the dedicated Mural space, highlighting the ultimate Sprint question that the decider chose. (1 min) |
| Recap day. <br/> Short intro to next day and share the video with the next day exercise instructions. | 5 mins | Mural, Zoom | Summarise activities of the day and decisions. Brief walkthrough of the next day's activities and wrap up the day. |

### Day 2
  |  Activity  | Duration | Tool  | Description  |
|---|---|---|---|
|  Summary of Day 1 outcomes | 5 mins | Mural | Go through the previous day's activities, the Long term goal and the top voted Sprint questions, highlighting the ultimate Sprint question, and summarise the concept solution sketching homework exercise. |
|  Concept gallery review | 20 mins | Mural | • Everyone takes some time to read through and look at every aspect of each of the sketches in the Concept Gallery. The concept sketches are anonymous to avoid bias (15 mins). <br/> • The team will then vote on their favorite concepts and/or components of a concept via the red dots. When they see something that interests them and they think it will help solve the long term goal/challenges they can add one or more dots. They can use as many red dots as they want. Be frivolous when adding dots but if you really like or think something is important, add more to draw attention to it (5 mins).<br/> Note: If anyone has any questions about a concept sketch create a red sticky and write that question down placing it under the concept sketches. |
|  Speed critique | 5 mins | Mural | • The facilitator walks through each of the concepts, briefly summarizing each concept (to the best of their ability) with a focus on the areas that have been dotted. <br/> • During this time the facilitator will also try to answer any of the red post-it questions. <br/> • When the facilitator believes they’ve reached the end of their summary for that concept, ask the team if there was a concept that was voted on but not discussed or if the point of the red dot vote was missed in the discussion.
|  Straw Poll | ~15 mins | Mural | • All the participants, besides the Decider, vote using the larger green dot by adding their initials to it and placing it on the concept sketch they believe is the best one that will best fulfill the long term goal and challenges of this sprint and is worthy of being prototyped (2 mins) <br/> • Each participant will create a post-it note that explains their reasoning for choosing the concept. (5 mins) <br/> • Each participant will then get 1 minute to read through their post-it and attempt to sell their preferred concept to the Decider and the other participants. (5-10 mins) |
| Super Vote (The Decider) | 10 mins | Mural | • The Decider makes their final decision of which of the concepts is the one to move forward with. <br/> • The decider can discuss their thought process and any questions with the rest of the participants. <br/> • They will get 2 green smiley stickers to vote with. Placing one on the concept they want to move forward with and the second, optional smiley, can be used to mark any other area of any other concept they think should also be incorporated into the prototype. |


### Day 3
 |  Activity  | Duration | Tool  | Description  |
|---|---|---|---|
| User test flow | 25 mins | Mural | • Each participant writes (on separate post-its) 6 steps/actions that represent a step of a flow (you can think of a high-level prototype flow) from start to finish. Place them in the appropriate location on the User Test section. (10 mins) <br/> • Each participant takes 1 minute to walk the team through their flows one-by-one (5-10 mins total). Note: It's best to have the Decider go last. <br/> • Voting: All the Sprint participants get one red dot (the Decider gets 2) to vote on the flow row they think is the best foundation for the prototype. <br/> • After everyone has voted the Decider will vote on the row they think is best with one dot using the second dot to, optionally, vote on an element of another flow they think should be incorporated into the prototype. (5 mins) <br/> • If the second dot is used copy the specific sticky into the main flow voted by the Decider. | 
| Storyboard | 45 mins | Mural | • Copy the winning flow from the User Test Flow exercise to the Storyboard/Prototype section placing each individual post-it note into its own container. <br/> • Look at the sketch concepts and move over any relevant screens that fulfill the needs of the sticky note in that container. You can move the entire concept or screen capture cut/paste parts of concepts. Note: Don’t add any unnecessary details or ideas that aren’t needed for the end result prototype <br/> • Fill in the details that are required for each step described in the sticky. |
| Recap day | 5 mins | Mural, Zoom | Summarise activities of the day and decisions. Brief walkthrough of the next day's activities and wrap up the day. |

### Day 4
 |  Activity  | Duration | Tool  | Description  |
|---|---|---|---|
| Validate Prototype | 30 mins | Mural | • Go through the Prototype created by the Product designer or Front end developer and discuss any inaccuracies or missing content. |
| Wrap up the Sprint | 15 mins | Zoom, GitLab | • Recap the Sprint and discuss next steps. Create user testing issues. |

### Day 5
 |  Activity  | Duration | Tool  | Description  |
|---|---|---|---|
| Prototype testing with 5 users | ~45 mins | Figma or code/Zoom | • Test the prototype with users. |

## Ground Rules
*  Honor the Facilitator's directions. They're the guide for the entire process.
*  Minimise distractions: During the week you will need to dedicate some hours to the Sprint for async tasks and sync video conferences. During this time we recommend blocking time in your calendar and having devices or apps with notifications turned off during that time. 
*  All opinions are valid and are equally important, however, the Decider has the ultimate, final decision.
*  Everyone is an active participant in a sync activity (with the exception of the Observers).
*  One conversation at a time.
*  Document as much as you can: We should have concrete outputs to share with broader team. Also interesting ideas or fixes should be documented to be transferred in issues for our backlog.
*  Stick to scheduled breaks during sync calls. The Facilitator will guide each session and set break times.
*  The Sprint is one of the few chances we get to work so closely together. Have fun!
